Imports System
Imports System.Runtime.Serialization
Imports System.Runtime.Serialization.Formatters.Binary
Imports System.IO
Imports System.Collections

'
' Instances of this class respond to action events by serializing the
' instance of GameModel associated with this object.
'
<Serializable()> Public Class Deserializer
    Private ui As UserInterface

    ' Constructor
    ' ui - The UserInterface object that this object will obtain file names from.
    Public Sub New(ByVal ui As UserInterface)
        Me.ui = ui
    End Sub 'New

    '
    ' When a user interface event occurs that implies the
    ' deserialization of this game's state to a file, the user
    ' interface calls this method. 
    '
    Public Sub ActionPerformed(ByVal o As Object, ByVal a As EventArgs)
        Try
            Dim s As Stream = File.Open(ui.SaveFileName, FileMode.Open)
            Dim f As New BinaryFormatter()
            Dim r As TextFileReader = CType(f.Deserialize(s), TextFileReader)
            s.Close()
        Catch e As Exception
            ui.DisplayError(e.Message)
        End Try
    End Sub
End Class 'Deserializer
